<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package CORBESIER
 * @since CORBESIER 1.0
 */

							do_action( 'corbesier_action_page_content_end_text' );
							
							// Widgets area below the content
							corbesier_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'corbesier_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'corbesier_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'corbesier_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'corbesier_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$corbesier_body_style = corbesier_get_theme_option( 'body_style' );
					$corbesier_widgets_name = corbesier_get_theme_option( 'widgets_below_page' );
					$corbesier_show_widgets = ! corbesier_is_off( $corbesier_widgets_name ) && is_active_sidebar( $corbesier_widgets_name );
					$corbesier_show_related = corbesier_is_single() && corbesier_get_theme_option( 'related_position' ) == 'below_page';
					if ( $corbesier_show_widgets || $corbesier_show_related ) {
						if ( 'fullscreen' != $corbesier_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $corbesier_show_related ) {
							do_action( 'corbesier_action_related_posts' );
						}

						// Widgets area below page content
						if ( $corbesier_show_widgets ) {
							corbesier_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $corbesier_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'corbesier_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'corbesier_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! corbesier_is_singular( 'post' ) && ! corbesier_is_singular( 'attachment' ) ) || ! in_array ( corbesier_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="corbesier_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'corbesier_action_before_footer' );

				// Footer
				$corbesier_footer_type = corbesier_get_theme_option( 'footer_type' );
				if ( 'custom' == $corbesier_footer_type && ! corbesier_is_layouts_available() ) {
					$corbesier_footer_type = 'default';
				}
				get_template_part( apply_filters( 'corbesier_filter_get_template_part', "templates/footer-" . sanitize_file_name( $corbesier_footer_type ) ) );

				do_action( 'corbesier_action_after_footer' );

			}
			?>

			<?php do_action( 'corbesier_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'corbesier_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'corbesier_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>