<div class="front_page_section front_page_section_contacts<?php
	$corbesier_scheme = corbesier_get_theme_option( 'front_page_contacts_scheme' );
	if ( ! empty( $corbesier_scheme ) && ! corbesier_is_inherit( $corbesier_scheme ) ) {
		echo ' scheme_' . esc_attr( $corbesier_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( corbesier_get_theme_option( 'front_page_contacts_paddings' ) );
	if ( corbesier_get_theme_option( 'front_page_contacts_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$corbesier_css      = '';
		$corbesier_bg_image = corbesier_get_theme_option( 'front_page_contacts_bg_image' );
		if ( ! empty( $corbesier_bg_image ) ) {
			$corbesier_css .= 'background-image: url(' . esc_url( corbesier_get_attachment_url( $corbesier_bg_image ) ) . ');';
		}
		if ( ! empty( $corbesier_css ) ) {
			echo ' style="' . esc_attr( $corbesier_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$corbesier_anchor_icon = corbesier_get_theme_option( 'front_page_contacts_anchor_icon' );
	$corbesier_anchor_text = corbesier_get_theme_option( 'front_page_contacts_anchor_text' );
if ( ( ! empty( $corbesier_anchor_icon ) || ! empty( $corbesier_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_contacts"'
									. ( ! empty( $corbesier_anchor_icon ) ? ' icon="' . esc_attr( $corbesier_anchor_icon ) . '"' : '' )
									. ( ! empty( $corbesier_anchor_text ) ? ' title="' . esc_attr( $corbesier_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_contacts_inner
	<?php
	if ( corbesier_get_theme_option( 'front_page_contacts_fullheight' ) ) {
		echo ' corbesier-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$corbesier_css      = '';
			$corbesier_bg_mask  = corbesier_get_theme_option( 'front_page_contacts_bg_mask' );
			$corbesier_bg_color_type = corbesier_get_theme_option( 'front_page_contacts_bg_color_type' );
			if ( 'custom' == $corbesier_bg_color_type ) {
				$corbesier_bg_color = corbesier_get_theme_option( 'front_page_contacts_bg_color' );
			} elseif ( 'scheme_bg_color' == $corbesier_bg_color_type ) {
				$corbesier_bg_color = corbesier_get_scheme_color( 'bg_color', $corbesier_scheme );
			} else {
				$corbesier_bg_color = '';
			}
			if ( ! empty( $corbesier_bg_color ) && $corbesier_bg_mask > 0 ) {
				$corbesier_css .= 'background-color: ' . esc_attr(
					1 == $corbesier_bg_mask ? $corbesier_bg_color : corbesier_hex2rgba( $corbesier_bg_color, $corbesier_bg_mask )
				) . ';';
			}
			if ( ! empty( $corbesier_css ) ) {
				echo ' style="' . esc_attr( $corbesier_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_contacts_content_wrap content_wrap">
			<?php

			// Title and description
			$corbesier_caption     = corbesier_get_theme_option( 'front_page_contacts_caption' );
			$corbesier_description = corbesier_get_theme_option( 'front_page_contacts_description' );
			if ( ! empty( $corbesier_caption ) || ! empty( $corbesier_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $corbesier_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_contacts_caption front_page_block_<?php echo ! empty( $corbesier_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( $corbesier_caption, 'corbesier_kses_content' );
					?>
					</h2>
					<?php
				}

				// Description
				if ( ! empty( $corbesier_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_contacts_description front_page_block_<?php echo ! empty( $corbesier_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( wpautop( $corbesier_description ), 'corbesier_kses_content' );
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$corbesier_content = corbesier_get_theme_option( 'front_page_contacts_content' );
			$corbesier_layout  = corbesier_get_theme_option( 'front_page_contacts_layout' );
			if ( 'columns' == $corbesier_layout && ( ! empty( $corbesier_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_columns front_page_section_contacts_columns columns_wrap">
					<div class="column-1_3">
				<?php
			}

			if ( ( ! empty( $corbesier_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_content front_page_section_contacts_content front_page_block_<?php echo ! empty( $corbesier_content ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $corbesier_content, 'corbesier_kses_content' );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $corbesier_layout && ( ! empty( $corbesier_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div><div class="column-2_3">
				<?php
			}

			// Shortcode output
			$corbesier_sc = corbesier_get_theme_option( 'front_page_contacts_shortcode' );
			if ( ! empty( $corbesier_sc ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_output front_page_section_contacts_output front_page_block_<?php echo ! empty( $corbesier_sc ) ? 'filled' : 'empty'; ?>">
					<?php
					corbesier_show_layout( do_shortcode( $corbesier_sc ) );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $corbesier_layout && ( ! empty( $corbesier_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>

		</div>
	</div>
</div>
