<div class="front_page_section front_page_section_subscribe<?php
	$corbesier_scheme = corbesier_get_theme_option( 'front_page_subscribe_scheme' );
	if ( ! empty( $corbesier_scheme ) && ! corbesier_is_inherit( $corbesier_scheme ) ) {
		echo ' scheme_' . esc_attr( $corbesier_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( corbesier_get_theme_option( 'front_page_subscribe_paddings' ) );
	if ( corbesier_get_theme_option( 'front_page_subscribe_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$corbesier_css      = '';
		$corbesier_bg_image = corbesier_get_theme_option( 'front_page_subscribe_bg_image' );
		if ( ! empty( $corbesier_bg_image ) ) {
			$corbesier_css .= 'background-image: url(' . esc_url( corbesier_get_attachment_url( $corbesier_bg_image ) ) . ');';
		}
		if ( ! empty( $corbesier_css ) ) {
			echo ' style="' . esc_attr( $corbesier_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$corbesier_anchor_icon = corbesier_get_theme_option( 'front_page_subscribe_anchor_icon' );
	$corbesier_anchor_text = corbesier_get_theme_option( 'front_page_subscribe_anchor_text' );
if ( ( ! empty( $corbesier_anchor_icon ) || ! empty( $corbesier_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_subscribe"'
									. ( ! empty( $corbesier_anchor_icon ) ? ' icon="' . esc_attr( $corbesier_anchor_icon ) . '"' : '' )
									. ( ! empty( $corbesier_anchor_text ) ? ' title="' . esc_attr( $corbesier_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_subscribe_inner
	<?php
	if ( corbesier_get_theme_option( 'front_page_subscribe_fullheight' ) ) {
		echo ' corbesier-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$corbesier_css      = '';
			$corbesier_bg_mask  = corbesier_get_theme_option( 'front_page_subscribe_bg_mask' );
			$corbesier_bg_color_type = corbesier_get_theme_option( 'front_page_subscribe_bg_color_type' );
			if ( 'custom' == $corbesier_bg_color_type ) {
				$corbesier_bg_color = corbesier_get_theme_option( 'front_page_subscribe_bg_color' );
			} elseif ( 'scheme_bg_color' == $corbesier_bg_color_type ) {
				$corbesier_bg_color = corbesier_get_scheme_color( 'bg_color', $corbesier_scheme );
			} else {
				$corbesier_bg_color = '';
			}
			if ( ! empty( $corbesier_bg_color ) && $corbesier_bg_mask > 0 ) {
				$corbesier_css .= 'background-color: ' . esc_attr(
					1 == $corbesier_bg_mask ? $corbesier_bg_color : corbesier_hex2rgba( $corbesier_bg_color, $corbesier_bg_mask )
				) . ';';
			}
			if ( ! empty( $corbesier_css ) ) {
				echo ' style="' . esc_attr( $corbesier_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_subscribe_content_wrap content_wrap">
			<?php
			// Caption
			$corbesier_caption = corbesier_get_theme_option( 'front_page_subscribe_caption' );
			if ( ! empty( $corbesier_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_subscribe_caption front_page_block_<?php echo ! empty( $corbesier_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $corbesier_caption, 'corbesier_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$corbesier_description = corbesier_get_theme_option( 'front_page_subscribe_description' );
			if ( ! empty( $corbesier_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_subscribe_description front_page_block_<?php echo ! empty( $corbesier_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $corbesier_description ), 'corbesier_kses_content' ); ?></div>
				<?php
			}

			// Content
			$corbesier_sc = corbesier_get_theme_option( 'front_page_subscribe_shortcode' );
			if ( ! empty( $corbesier_sc ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_output front_page_section_subscribe_output front_page_block_<?php echo ! empty( $corbesier_sc ) ? 'filled' : 'empty'; ?>">
				<?php
					corbesier_show_layout( do_shortcode( $corbesier_sc ) );
				?>
				</div>
				<?php
			}
			?>
		</div>
	</div>
</div>
