<?php
$corbesier_slider_sc = corbesier_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $corbesier_slider_sc ) && strpos( $corbesier_slider_sc, '[' ) !== false && strpos( $corbesier_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( corbesier_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$corbesier_anchor_icon = corbesier_get_theme_option( 'front_page_title_anchor_icon' );
		$corbesier_anchor_text = corbesier_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $corbesier_anchor_icon ) || ! empty( $corbesier_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $corbesier_anchor_icon ) ? ' icon="' . esc_attr( $corbesier_anchor_icon ) . '"' : '' )
									. ( ! empty( $corbesier_anchor_text ) ? ' title="' . esc_attr( $corbesier_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $corbesier_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$corbesier_scheme = corbesier_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $corbesier_scheme ) && ! corbesier_is_inherit( $corbesier_scheme ) ) {
			echo ' scheme_' . esc_attr( $corbesier_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( corbesier_get_theme_option( 'front_page_title_paddings' ) );
		if ( corbesier_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$corbesier_css      = '';
		$corbesier_bg_image = corbesier_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $corbesier_bg_image ) ) {
			$corbesier_css .= 'background-image: url(' . esc_url( corbesier_get_attachment_url( $corbesier_bg_image ) ) . ');';
		}
		if ( ! empty( $corbesier_css ) ) {
			echo ' style="' . esc_attr( $corbesier_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$corbesier_anchor_icon = corbesier_get_theme_option( 'front_page_title_anchor_icon' );
		$corbesier_anchor_text = corbesier_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $corbesier_anchor_icon ) || ! empty( $corbesier_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $corbesier_anchor_icon ) ? ' icon="' . esc_attr( $corbesier_anchor_icon ) . '"' : '' )
									. ( ! empty( $corbesier_anchor_text ) ? ' title="' . esc_attr( $corbesier_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( corbesier_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' corbesier-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$corbesier_css      = '';
			$corbesier_bg_mask  = corbesier_get_theme_option( 'front_page_title_bg_mask' );
			$corbesier_bg_color_type = corbesier_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $corbesier_bg_color_type ) {
				$corbesier_bg_color = corbesier_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $corbesier_bg_color_type ) {
				$corbesier_bg_color = corbesier_get_scheme_color( 'bg_color', $corbesier_scheme );
			} else {
				$corbesier_bg_color = '';
			}
			if ( ! empty( $corbesier_bg_color ) && $corbesier_bg_mask > 0 ) {
				$corbesier_css .= 'background-color: ' . esc_attr(
					1 == $corbesier_bg_mask ? $corbesier_bg_color : corbesier_hex2rgba( $corbesier_bg_color, $corbesier_bg_mask )
				) . ';';
			}
			if ( ! empty( $corbesier_css ) ) {
				echo ' style="' . esc_attr( $corbesier_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$corbesier_caption = corbesier_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $corbesier_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $corbesier_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $corbesier_caption, 'corbesier_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$corbesier_description = corbesier_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $corbesier_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $corbesier_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $corbesier_description ), 'corbesier_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( corbesier_get_theme_option( 'front_page_title_button1_link' ) != '' || corbesier_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						corbesier_show_layout( corbesier_customizer_partial_refresh_front_page_title_button1_link() );
						corbesier_show_layout( corbesier_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
