<?php
$corbesier_woocommerce_sc = corbesier_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $corbesier_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$corbesier_scheme = corbesier_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $corbesier_scheme ) && ! corbesier_is_inherit( $corbesier_scheme ) ) {
			echo ' scheme_' . esc_attr( $corbesier_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( corbesier_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( corbesier_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$corbesier_css      = '';
			$corbesier_bg_image = corbesier_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $corbesier_bg_image ) ) {
				$corbesier_css .= 'background-image: url(' . esc_url( corbesier_get_attachment_url( $corbesier_bg_image ) ) . ');';
			}
			if ( ! empty( $corbesier_css ) ) {
				echo ' style="' . esc_attr( $corbesier_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$corbesier_anchor_icon = corbesier_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$corbesier_anchor_text = corbesier_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $corbesier_anchor_icon ) || ! empty( $corbesier_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $corbesier_anchor_icon ) ? ' icon="' . esc_attr( $corbesier_anchor_icon ) . '"' : '' )
											. ( ! empty( $corbesier_anchor_text ) ? ' title="' . esc_attr( $corbesier_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( corbesier_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' corbesier-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$corbesier_css      = '';
				$corbesier_bg_mask  = corbesier_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$corbesier_bg_color_type = corbesier_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $corbesier_bg_color_type ) {
					$corbesier_bg_color = corbesier_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $corbesier_bg_color_type ) {
					$corbesier_bg_color = corbesier_get_scheme_color( 'bg_color', $corbesier_scheme );
				} else {
					$corbesier_bg_color = '';
				}
				if ( ! empty( $corbesier_bg_color ) && $corbesier_bg_mask > 0 ) {
					$corbesier_css .= 'background-color: ' . esc_attr(
						1 == $corbesier_bg_mask ? $corbesier_bg_color : corbesier_hex2rgba( $corbesier_bg_color, $corbesier_bg_mask )
					) . ';';
				}
				if ( ! empty( $corbesier_css ) ) {
					echo ' style="' . esc_attr( $corbesier_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$corbesier_caption     = corbesier_get_theme_option( 'front_page_woocommerce_caption' );
				$corbesier_description = corbesier_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $corbesier_caption ) || ! empty( $corbesier_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $corbesier_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $corbesier_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $corbesier_caption, 'corbesier_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $corbesier_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $corbesier_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $corbesier_description ), 'corbesier_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $corbesier_woocommerce_sc ) {
						$corbesier_woocommerce_sc_ids      = corbesier_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$corbesier_woocommerce_sc_per_page = count( explode( ',', $corbesier_woocommerce_sc_ids ) );
					} else {
						$corbesier_woocommerce_sc_per_page = max( 1, (int) corbesier_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$corbesier_woocommerce_sc_columns = max( 1, min( $corbesier_woocommerce_sc_per_page, (int) corbesier_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$corbesier_woocommerce_sc}"
										. ( 'products' == $corbesier_woocommerce_sc
												? ' ids="' . esc_attr( $corbesier_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $corbesier_woocommerce_sc
												? ' category="' . esc_attr( corbesier_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $corbesier_woocommerce_sc
												? ' orderby="' . esc_attr( corbesier_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( corbesier_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $corbesier_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $corbesier_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
