<?php
/**
 * The Header: Logo and main menu
 *
 * @package CORBESIER
 * @since CORBESIER 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( corbesier_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'corbesier_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'corbesier_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('corbesier_action_body_wrap_attributes'); ?>>

		<?php do_action( 'corbesier_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'corbesier_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('corbesier_action_page_wrap_attributes'); ?>>

			<?php do_action( 'corbesier_action_page_wrap_start' ); ?>

			<?php
			$corbesier_full_post_loading = ( corbesier_is_singular( 'post' ) || corbesier_is_singular( 'attachment' ) ) && corbesier_get_value_gp( 'action' ) == 'full_post_loading';
			$corbesier_prev_post_loading = ( corbesier_is_singular( 'post' ) || corbesier_is_singular( 'attachment' ) ) && corbesier_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $corbesier_full_post_loading && ! $corbesier_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="corbesier_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to content", 'corbesier' ); ?></a>
				<?php if ( corbesier_sidebar_present() ) { ?>
				<a class="corbesier_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to sidebar", 'corbesier' ); ?></a>
				<?php } ?>
				<a class="corbesier_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to footer", 'corbesier' ); ?></a>

				<?php
				do_action( 'corbesier_action_before_header' );

				// Header
				$corbesier_header_type = corbesier_get_theme_option( 'header_type' );
				if ( 'custom' == $corbesier_header_type && ! corbesier_is_layouts_available() ) {
					$corbesier_header_type = 'default';
				}
				get_template_part( apply_filters( 'corbesier_filter_get_template_part', "templates/header-" . sanitize_file_name( $corbesier_header_type ) ) );

				// Side menu
				if ( in_array( corbesier_get_theme_option( 'menu_side' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'corbesier_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				get_template_part( apply_filters( 'corbesier_filter_get_template_part', 'templates/header-navi-mobile' ) );

				do_action( 'corbesier_action_after_header' );

			}
			?>

			<?php do_action( 'corbesier_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( corbesier_is_off( corbesier_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $corbesier_header_type ) ) {
						$corbesier_header_type = corbesier_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $corbesier_header_type && corbesier_is_layouts_available() ) {
						$corbesier_header_id = corbesier_get_custom_header_id();
						if ( $corbesier_header_id > 0 ) {
							$corbesier_header_meta = corbesier_get_custom_layout_meta( $corbesier_header_id );
							if ( ! empty( $corbesier_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$corbesier_footer_type = corbesier_get_theme_option( 'footer_type' );
					if ( 'custom' == $corbesier_footer_type && corbesier_is_layouts_available() ) {
						$corbesier_footer_id = corbesier_get_custom_footer_id();
						if ( $corbesier_footer_id ) {
							$corbesier_footer_meta = corbesier_get_custom_layout_meta( $corbesier_footer_id );
							if ( ! empty( $corbesier_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'corbesier_action_page_content_wrap_class', $corbesier_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'corbesier_filter_is_prev_post_loading', $corbesier_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( corbesier_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'corbesier_action_page_content_wrap_data', $corbesier_prev_post_loading );
			?>>
				<?php
				do_action( 'corbesier_action_page_content_wrap', $corbesier_full_post_loading || $corbesier_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'corbesier_filter_single_post_header', corbesier_is_singular( 'post' ) || corbesier_is_singular( 'attachment' ) ) ) {
					if ( $corbesier_prev_post_loading ) {
						if ( corbesier_get_theme_option( 'posts_navigation_scroll_which_block' ) != 'article' ) {
							do_action( 'corbesier_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$corbesier_path = apply_filters( 'corbesier_filter_get_template_part', 'templates/single-styles/' . corbesier_get_theme_option( 'single_style' ) );
					if ( corbesier_get_file_dir( $corbesier_path . '.php' ) != '' ) {
						get_template_part( $corbesier_path );
					}
				}

				// Widgets area above page
				$corbesier_body_style   = corbesier_get_theme_option( 'body_style' );
				$corbesier_widgets_name = corbesier_get_theme_option( 'widgets_above_page' );
				$corbesier_show_widgets = ! corbesier_is_off( $corbesier_widgets_name ) && is_active_sidebar( $corbesier_widgets_name );
				if ( $corbesier_show_widgets ) {
					if ( 'fullscreen' != $corbesier_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					corbesier_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $corbesier_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'corbesier_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $corbesier_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'corbesier_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'corbesier_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="corbesier_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( corbesier_is_singular( 'post' ) || corbesier_is_singular( 'attachment' ) )
							&& $corbesier_prev_post_loading 
							&& corbesier_get_theme_option( 'posts_navigation_scroll_which_block' ) == 'article'
						) {
							do_action( 'corbesier_action_between_posts' );
						}

						// Widgets area above content
						corbesier_create_widgets_area( 'widgets_above_content' );

						do_action( 'corbesier_action_page_content_start_text' );
