<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package CORBESIER
 * @since CORBESIER 1.0
 */

$corbesier_template = apply_filters( 'corbesier_filter_get_template_part', corbesier_blog_archive_get_template() );

if ( ! empty( $corbesier_template ) && 'index' != $corbesier_template ) {

	get_template_part( $corbesier_template );

} else {

	corbesier_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$corbesier_stickies   = is_home()
								|| ( in_array( corbesier_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) corbesier_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$corbesier_post_type  = corbesier_get_theme_option( 'post_type' );
		$corbesier_args       = array(
								'blog_style'     => corbesier_get_theme_option( 'blog_style' ),
								'post_type'      => $corbesier_post_type,
								'taxonomy'       => corbesier_get_post_type_taxonomy( $corbesier_post_type ),
								'parent_cat'     => corbesier_get_theme_option( 'parent_cat' ),
								'posts_per_page' => corbesier_get_theme_option( 'posts_per_page' ),
								'sticky'         => corbesier_get_theme_option( 'sticky_style' ) == 'columns'
															&& is_array( $corbesier_stickies )
															&& count( $corbesier_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		corbesier_blog_archive_start();

		do_action( 'corbesier_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'corbesier_action_before_page_author' );
			get_template_part( apply_filters( 'corbesier_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'corbesier_action_after_page_author' );
		}

		if ( corbesier_get_theme_option( 'show_filters' ) ) {
			do_action( 'corbesier_action_before_page_filters' );
			corbesier_show_filters( $corbesier_args );
			do_action( 'corbesier_action_after_page_filters' );
		} else {
			do_action( 'corbesier_action_before_page_posts' );
			corbesier_show_posts( array_merge( $corbesier_args, array( 'cat' => $corbesier_args['parent_cat'] ) ) );
			do_action( 'corbesier_action_after_page_posts' );
		}

		do_action( 'corbesier_action_blog_archive_end' );

		corbesier_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'corbesier_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'corbesier_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
