<?php
/**
 * Required plugins
 *
 * @package CORBESIER
 * @since CORBESIER 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
$corbesier_theme_required_plugins_groups = array(
	'core'          => esc_html__( 'Core', 'corbesier' ),
	'page_builders' => esc_html__( 'Page Builders', 'corbesier' ),
	'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'corbesier' ),
	'socials'       => esc_html__( 'Socials and Communities', 'corbesier' ),
	'events'        => esc_html__( 'Events and Appointments', 'corbesier' ),
	'content'       => esc_html__( 'Content', 'corbesier' ),
	'other'         => esc_html__( 'Other', 'corbesier' ),
);
$corbesier_theme_required_plugins        = array(
	'trx_addons'                 => array(
		'title'       => esc_html__( 'ThemeREX Addons', 'corbesier' ),
		'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'corbesier' ),
		'required'    => true,
		'logo'        => 'trx_addons.png',
		'group'       => $corbesier_theme_required_plugins_groups['core'],
	),
	'elementor'                  => array(
		'title'       => esc_html__( 'Elementor', 'corbesier' ),
		'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'corbesier' ),
		'required'    => false,
		'logo'        => 'elementor.png',
		'group'       => $corbesier_theme_required_plugins_groups['page_builders'],
	),
	'gutenberg'                  => array(
		'title'       => esc_html__( 'Gutenberg', 'corbesier' ),
		'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'corbesier' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'gutenberg.png',
		'group'       => $corbesier_theme_required_plugins_groups['page_builders'],
	),
	'js_composer'                => array(
		'title'       => esc_html__( 'WPBakery PageBuilder', 'corbesier' ),
		'description' => esc_html__( "Popular PageBuilder which allows you to create excellent pages", 'corbesier' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'js_composer.jpg',
		'group'       => $corbesier_theme_required_plugins_groups['page_builders'],
	),
	'woocommerce'                => array(
		'title'       => esc_html__( 'WooCommerce', 'corbesier' ),
		'description' => esc_html__( "Connect the store to your website and start selling now", 'corbesier' ),
		'required'    => false,
		'install'     => false,
		'logo'        => 'woocommerce.png',
		'group'       => $corbesier_theme_required_plugins_groups['ecommerce'],
	),
	'elegro-payment'             => array(
		'title'       => esc_html__( 'Elegro Crypto Payment', 'corbesier' ),
		'description' => esc_html__( "Extends WooCommerce Payment Gateways with an elegro Crypto Payment", 'corbesier' ),
		'required'    => false,
		'install'     => false,
		'logo'        => 'elegro-payment.png',
		'group'       => $corbesier_theme_required_plugins_groups['ecommerce'],
	),
	'instagram-feed'             => array(
		'title'       => esc_html__( 'Instagram Feed', 'corbesier' ),
		'description' => esc_html__( "Displays the latest photos from your profile on Instagram", 'corbesier' ),
		'required'    => false,
        'logo'        => 'instagram-feed.png',
		'group'       => $corbesier_theme_required_plugins_groups['socials'],
	),
	'mailchimp-for-wp'           => array(
		'title'       => esc_html__( 'MailChimp for WP', 'corbesier' ),
		'description' => esc_html__( "Allows visitors to subscribe to newsletters", 'corbesier' ),
		'required'    => false,
		'logo'        => 'mailchimp-for-wp.png',
		'group'       => $corbesier_theme_required_plugins_groups['socials'],
	),
	'booked'                     => array(
		'title'       => esc_html__( 'Booked Appointments', 'corbesier' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'booked.png',
		'group'       => $corbesier_theme_required_plugins_groups['events'],
	),
	'the-events-calendar'        => array(
		'title'       => esc_html__( 'The Events Calendar', 'corbesier' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'the-events-calendar.png',
		'group'       => $corbesier_theme_required_plugins_groups['events'],
	),
	'contact-form-7'             => array(
		'title'       => esc_html__( 'Contact Form 7', 'corbesier' ),
		'description' => esc_html__( "CF7 allows you to create an unlimited number of contact forms", 'corbesier' ),
		'required'    => false,
		'logo'        => 'contact-form-7.png',
		'group'       => $corbesier_theme_required_plugins_groups['content'],
	),

	'latepoint'                  => array(
		'title'       => esc_html__( 'LatePoint', 'corbesier' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => corbesier_get_file_url( 'plugins/latepoint/latepoint.png' ),
		'group'       => $corbesier_theme_required_plugins_groups['events'],
	),
	'advanced-popups'                  => array(
		'title'       => esc_html__( 'Advanced Popups', 'corbesier' ),
		'description' => '',
		'required'    => false,
        'logo'        => corbesier_get_file_url( 'plugins/advanced-popups/advanced-popups.jpg' ),
		'group'       => $corbesier_theme_required_plugins_groups['content'],
	),
	'devvn-image-hotspot'                  => array(
		'title'       => esc_html__( 'Image Hotspot by DevVN', 'corbesier' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => corbesier_get_file_url( 'plugins/devvn-image-hotspot/devvn-image-hotspot.png' ),
		'group'       => $corbesier_theme_required_plugins_groups['content'],
	),
	'ti-woocommerce-wishlist'                  => array(
		'title'       => esc_html__( 'TI WooCommerce Wishlist', 'corbesier' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => corbesier_get_file_url( 'plugins/ti-woocommerce-wishlist/ti-woocommerce-wishlist.png' ),
		'group'       => $corbesier_theme_required_plugins_groups['ecommerce'],
	),
	'woo-smart-quick-view'                  => array(
		'title'       => esc_html__( 'WPC Smart Quick View for WooCommerce', 'corbesier' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => corbesier_get_file_url( 'plugins/woo-smart-quick-view/woo-smart-quick-view.png' ),
		'group'       => $corbesier_theme_required_plugins_groups['ecommerce'],
	),
	'twenty20'                  => array(
		'title'       => esc_html__( 'Twenty20 Image Before-After', 'corbesier' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => corbesier_get_file_url( 'plugins/twenty20/twenty20.png' ),
		'group'       => $corbesier_theme_required_plugins_groups['content'],
	),
	'essential-grid'             => array(
		'title'       => esc_html__( 'Essential Grid', 'corbesier' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'essential-grid.png',
		'group'       => $corbesier_theme_required_plugins_groups['content'],
	),
	'revslider'                  => array(
		'title'       => esc_html__( 'Revolution Slider', 'corbesier' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'revslider.png',
		'group'       => $corbesier_theme_required_plugins_groups['content'],
	),
	'sitepress-multilingual-cms' => array(
		'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'corbesier' ),
		'description' => esc_html__( "Allows you to make your website multilingual", 'corbesier' ),
		'required'    => false,
		'install'     => false,      // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'sitepress-multilingual-cms.png',
		'group'       => $corbesier_theme_required_plugins_groups['content'],
	),
	'wp-gdpr-compliance'         => array(
		'title'       => esc_html__( 'Cookie Information', 'corbesier' ),
		'description' => esc_html__( "Allow visitors to decide for themselves what personal data they want to store on your site", 'corbesier' ),
		'required'    => false,
		'logo'        => 'wp-gdpr-compliance.png',
		'group'       => $corbesier_theme_required_plugins_groups['other'],
	),
	'trx_updater'                => array(
		'title'       => esc_html__( 'ThemeREX Updater', 'corbesier' ),
		'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'corbesier' ),
		'required'    => false,
		'logo'        => 'trx_updater.png',
		'group'       => $corbesier_theme_required_plugins_groups['other'],
	),
);

if ( CORBESIER_THEME_FREE ) {
	unset( $corbesier_theme_required_plugins['js_composer'] );
	unset( $corbesier_theme_required_plugins['booked'] );
	unset( $corbesier_theme_required_plugins['the-events-calendar'] );
	unset( $corbesier_theme_required_plugins['calculated-fields-form'] );
	unset( $corbesier_theme_required_plugins['essential-grid'] );
	unset( $corbesier_theme_required_plugins['revslider'] );
	unset( $corbesier_theme_required_plugins['sitepress-multilingual-cms'] );
	unset( $corbesier_theme_required_plugins['trx_updater'] );
	unset( $corbesier_theme_required_plugins['trx_popup'] );
}

// Add plugins list to the global storage
corbesier_storage_set( 'required_plugins', $corbesier_theme_required_plugins );
