<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package CORBESIER
 * @since CORBESIER 1.0.50
 */

$corbesier_template_args = get_query_var( 'corbesier_template_args' );
if ( is_array( $corbesier_template_args ) ) {
	$corbesier_columns    = empty( $corbesier_template_args['columns'] ) ? 2 : max( 1, $corbesier_template_args['columns'] );
	$corbesier_blog_style = array( $corbesier_template_args['type'], $corbesier_columns );
} else {
	$corbesier_blog_style = explode( '_', corbesier_get_theme_option( 'blog_style' ) );
	$corbesier_columns    = empty( $corbesier_blog_style[1] ) ? 2 : max( 1, $corbesier_blog_style[1] );
}
$corbesier_blog_id       = corbesier_get_custom_blog_id( join( '_', $corbesier_blog_style ) );
$corbesier_blog_style[0] = str_replace( 'blog-custom-', '', $corbesier_blog_style[0] );
$corbesier_expanded      = ! corbesier_sidebar_present() && corbesier_get_theme_option( 'expand_content' ) == 'expand';
$corbesier_components    = ! empty( $corbesier_template_args['meta_parts'] )
							? ( is_array( $corbesier_template_args['meta_parts'] )
								? join( ',', $corbesier_template_args['meta_parts'] )
								: $corbesier_template_args['meta_parts']
								)
							: corbesier_array_get_keys_by_value( corbesier_get_theme_option( 'meta_parts' ) );
$corbesier_post_format   = get_post_format();
$corbesier_post_format   = empty( $corbesier_post_format ) ? 'standard' : str_replace( 'post-format-', '', $corbesier_post_format );

$corbesier_blog_meta     = corbesier_get_custom_layout_meta( $corbesier_blog_id );
$corbesier_custom_style  = ! empty( $corbesier_blog_meta['scripts_required'] ) ? $corbesier_blog_meta['scripts_required'] : 'none';

if ( ! empty( $corbesier_template_args['slider'] ) || $corbesier_columns > 1 || ! corbesier_is_off( $corbesier_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $corbesier_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( corbesier_is_off( $corbesier_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $corbesier_custom_style ) ) . "-1_{$corbesier_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $corbesier_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $corbesier_columns )
					. ' post_layout_' . esc_attr( $corbesier_blog_style[0] )
					. ' post_layout_' . esc_attr( $corbesier_blog_style[0] ) . '_' . esc_attr( $corbesier_columns )
					. ( ! corbesier_is_off( $corbesier_custom_style )
						? ' post_layout_' . esc_attr( $corbesier_custom_style )
							. ' post_layout_' . esc_attr( $corbesier_custom_style ) . '_' . esc_attr( $corbesier_columns )
						: ''
						)
		);
	corbesier_add_blog_animation( $corbesier_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'corbesier_action_show_layout', $corbesier_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $corbesier_template_args['slider'] ) || $corbesier_columns > 1 || ! corbesier_is_off( $corbesier_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
