<?php
/**
 * The template to display default site footer
 *
 * @package CORBESIER
 * @since CORBESIER 1.0.10
 */

$corbesier_footer_id = corbesier_get_custom_footer_id();
$corbesier_footer_meta = get_post_meta( $corbesier_footer_id, 'trx_addons_options', true );
if ( ! empty( $corbesier_footer_meta['margin'] ) ) {
	corbesier_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( corbesier_prepare_css_value( $corbesier_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $corbesier_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $corbesier_footer_id ) ) ); ?>
						<?php
						$corbesier_footer_scheme = corbesier_get_theme_option( 'footer_scheme' );
						if ( ! empty( $corbesier_footer_scheme ) && ! corbesier_is_inherit( $corbesier_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $corbesier_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'corbesier_action_show_layout', $corbesier_footer_id );
	?>
</footer><!-- /.footer_wrap -->
