<?php
/**
 * The template to display the site logo in the footer
 *
 * @package CORBESIER
 * @since CORBESIER 1.0.10
 */

// Logo
if ( corbesier_is_on( corbesier_get_theme_option( 'logo_in_footer' ) ) ) {
	$corbesier_logo_image = corbesier_get_logo_image( 'footer' );
	$corbesier_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $corbesier_logo_image['logo'] ) || ! empty( $corbesier_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $corbesier_logo_image['logo'] ) ) {
					$corbesier_attr = corbesier_getimagesize( $corbesier_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $corbesier_logo_image['logo'] ) . '"'
								. ( ! empty( $corbesier_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $corbesier_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'corbesier' ) . '"'
								. ( ! empty( $corbesier_attr[3] ) ? ' ' . wp_kses_data( $corbesier_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $corbesier_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $corbesier_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
