<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package CORBESIER
 * @since CORBESIER 1.0.10
 */

// Footer sidebar
$corbesier_footer_name    = corbesier_get_theme_option( 'footer_widgets' );
$corbesier_footer_present = ! corbesier_is_off( $corbesier_footer_name ) && is_active_sidebar( $corbesier_footer_name );
if ( $corbesier_footer_present ) {
	corbesier_storage_set( 'current_sidebar', 'footer' );
	$corbesier_footer_wide = corbesier_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $corbesier_footer_name ) ) {
		dynamic_sidebar( $corbesier_footer_name );
	}
	$corbesier_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $corbesier_out ) ) {
		$corbesier_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $corbesier_out );
		$corbesier_need_columns = true;   //or check: strpos($corbesier_out, 'columns_wrap')===false;
		if ( $corbesier_need_columns ) {
			$corbesier_columns = max( 0, (int) corbesier_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $corbesier_columns ) {
				$corbesier_columns = min( 4, max( 1, corbesier_tags_count( $corbesier_out, 'aside' ) ) );
			}
			if ( $corbesier_columns > 1 ) {
				$corbesier_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $corbesier_columns ) . ' widget', $corbesier_out );
			} else {
				$corbesier_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $corbesier_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'corbesier_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $corbesier_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $corbesier_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'corbesier_action_before_sidebar', 'footer' );
				corbesier_show_layout( $corbesier_out );
				do_action( 'corbesier_action_after_sidebar', 'footer' );
				if ( $corbesier_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $corbesier_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'corbesier_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
