<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package CORBESIER
 * @since CORBESIER 1.0.06
 */

$corbesier_header_css   = '';
$corbesier_header_image = get_header_image();
$corbesier_header_video = corbesier_get_header_video();
if ( ! empty( $corbesier_header_image ) && corbesier_trx_addons_featured_image_override( is_singular() || corbesier_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$corbesier_header_image = corbesier_get_current_mode_image( $corbesier_header_image );
}

$corbesier_header_id = corbesier_get_custom_header_id();
$corbesier_header_meta = get_post_meta( $corbesier_header_id, 'trx_addons_options', true );
if ( ! empty( $corbesier_header_meta['margin'] ) ) {
	corbesier_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( corbesier_prepare_css_value( $corbesier_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $corbesier_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $corbesier_header_id ) ) ); ?>
				<?php
				echo ! empty( $corbesier_header_image ) || ! empty( $corbesier_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $corbesier_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $corbesier_header_image ) {
					echo ' ' . esc_attr( corbesier_add_inline_css_class( 'background-image: url(' . esc_url( $corbesier_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( corbesier_is_on( corbesier_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight corbesier-full-height';
				}
				$corbesier_header_scheme = corbesier_get_theme_option( 'header_scheme' );
				if ( ! empty( $corbesier_header_scheme ) && ! corbesier_is_inherit( $corbesier_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $corbesier_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $corbesier_header_video ) ) {
		get_template_part( apply_filters( 'corbesier_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'corbesier_action_show_layout', $corbesier_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'corbesier_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
