<?php
/**
 * The template to display default site header
 *
 * @package CORBESIER
 * @since CORBESIER 1.0
 */

$corbesier_header_css   = '';
$corbesier_header_image = get_header_image();
$corbesier_header_video = corbesier_get_header_video();
if ( ! empty( $corbesier_header_image ) && corbesier_trx_addons_featured_image_override( is_singular() || corbesier_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$corbesier_header_image = corbesier_get_current_mode_image( $corbesier_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $corbesier_header_image ) || ! empty( $corbesier_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $corbesier_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $corbesier_header_image ) {
		echo ' ' . esc_attr( corbesier_add_inline_css_class( 'background-image: url(' . esc_url( $corbesier_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( corbesier_is_on( corbesier_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight corbesier-full-height';
	}
	$corbesier_header_scheme = corbesier_get_theme_option( 'header_scheme' );
	if ( ! empty( $corbesier_header_scheme ) && ! corbesier_is_inherit( $corbesier_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $corbesier_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $corbesier_header_video ) ) {
		get_template_part( apply_filters( 'corbesier_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'corbesier_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( corbesier_is_on( corbesier_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'corbesier_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'corbesier_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'corbesier_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
