<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package CORBESIER
 * @since CORBESIER 1.0
 */

$corbesier_args = get_query_var( 'corbesier_logo_args' );

// Site logo
$corbesier_logo_type   = isset( $corbesier_args['type'] ) ? $corbesier_args['type'] : '';
$corbesier_logo_image  = corbesier_get_logo_image( $corbesier_logo_type );
$corbesier_logo_text   = corbesier_is_on( corbesier_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$corbesier_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $corbesier_logo_image['logo'] ) || ! empty( $corbesier_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $corbesier_logo_image['logo'] ) ) {
			if ( empty( $corbesier_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($corbesier_logo_image['logo']) && (int) $corbesier_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$corbesier_attr = corbesier_getimagesize( $corbesier_logo_image['logo'] );
				echo '<img src="' . esc_url( $corbesier_logo_image['logo'] ) . '"'
						. ( ! empty( $corbesier_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $corbesier_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $corbesier_logo_text ) . '"'
						. ( ! empty( $corbesier_attr[3] ) ? ' ' . wp_kses_data( $corbesier_attr[3] ) : '' )
						. '>';
			}
		} else {
			corbesier_show_layout( corbesier_prepare_macros( $corbesier_logo_text ), '<span class="logo_text">', '</span>' );
			corbesier_show_layout( corbesier_prepare_macros( $corbesier_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
