<?php
/**
 * The template to show mobile menu (used only header_style == 'default')
 *
 * @package CORBESIER
 * @since CORBESIER 1.0
 */

$corbesier_show_widgets = corbesier_get_theme_option( 'widgets_menu_mobile_fullscreen' );
$corbesier_show_socials = corbesier_get_theme_option( 'menu_mobile_socials' );

?>
<div class="menu_mobile_overlay scheme_dark"></div>
<div class="menu_mobile menu_mobile_<?php echo esc_attr( corbesier_get_theme_option( 'menu_mobile_fullscreen' ) > 0 ? 'fullscreen' : 'narrow' ); ?> scheme_dark">
	<div class="menu_mobile_inner<?php echo esc_attr( $corbesier_show_widgets == 1  ? ' with_widgets' : '' ); ?>">
        <div class="menu_mobile_header_wrap">
            <?php
            // Logo
            set_query_var( 'corbesier_logo_args', array( 'type' => 'mobile' ) );
            get_template_part( apply_filters( 'corbesier_filter_get_template_part', 'templates/header-logo' ) );
            set_query_var( 'corbesier_logo_args', array() ); ?>

            <a class="menu_mobile_close menu_button_close" tabindex="0"><span class="menu_button_close_text"><?php esc_html_e('Close', 'corbesier')?></span><span class="menu_button_close_icon"></span></a>
        </div>
        <div class="menu_mobile_content_wrap content_wrap">
            <div class="menu_mobile_content_wrap_inner<?php echo esc_attr($corbesier_show_socials ? '' : ' without_socials'); ?>"><?php
            // Mobile menu
            $corbesier_menu_mobile = corbesier_get_nav_menu( 'menu_mobile' );
            if ( empty( $corbesier_menu_mobile ) ) {
                $corbesier_menu_mobile = apply_filters( 'corbesier_filter_get_mobile_menu', '' );
                if ( empty( $corbesier_menu_mobile ) ) {
                    $corbesier_menu_mobile = corbesier_get_nav_menu( 'menu_main' );
                    if ( empty( $corbesier_menu_mobile ) ) {
                        $corbesier_menu_mobile = corbesier_get_nav_menu();
                    }
                }
            }
            if ( ! empty( $corbesier_menu_mobile ) ) {
                $corbesier_menu_mobile = str_replace(
                    array( 'menu_main',   'id="menu-',        'sc_layouts_menu_nav', 'sc_layouts_menu ', 'sc_layouts_hide_on_mobile', 'hide_on_mobile' ),
                    array( 'menu_mobile', 'id="menu_mobile-', '',                    ' ',                '',                          '' ),
                    $corbesier_menu_mobile
                );
                if ( strpos( $corbesier_menu_mobile, '<nav ' ) === false ) {
                    $corbesier_menu_mobile = sprintf( '<nav class="menu_mobile_nav_area" itemscope="itemscope" itemtype="%1$s//schema.org/SiteNavigationElement">%2$s</nav>', esc_attr( corbesier_get_protocol( true ) ), $corbesier_menu_mobile );
                }
                corbesier_show_layout( apply_filters( 'corbesier_filter_menu_mobile_layout', $corbesier_menu_mobile ) );
            }
            // Social icons
            if($corbesier_show_socials) {
                corbesier_show_layout( corbesier_get_socials_links(), '<div class="socials_mobile">', '</div>' );
            }            
            ?>
            </div>
		</div><?php

        if ( $corbesier_show_widgets == 1 )  {
            ?><div class="menu_mobile_widgets_area"><?php
            // Create Widgets Area
            corbesier_create_widgets_area( 'widgets_additional_menu_mobile_fullscreen' );
            ?></div><?php
        } ?>

    </div>
</div>
